<?php
/**
 * C&O Twenty Twelve functions and definitions.
 */

/**
 * Adds a layout setting for Twenty Twelve.
 *
 * @param WP_Customize_Manager $wp_customize Customizer object.
 * @return void
 */
function co_customize_register( $wp_customize ) {

	// Make something happen!

}
add_action( 'customize_register', 'co_customize_register' );

/**
 * Enqueue Javascript postMessage handlers for the Customizer.
 *
 * Binds JS handlers to make the Customizer preview reload changes asynchronously.
 *
 * @since Twenty Twelve 1.0
 *
 * @return void
 */
function co_customize_preview_js() {
	wp_enqueue_script( 'co-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20140116', true );
}
add_action( 'customize_preview_init', 'co_customize_preview_js' );

/**
 * Add Twenty Twelve layout classes to the array of body classes.
 *
 * @param array $classes An array of existing body classes.
 * @return array
 */
function co_layout_classes( $classes ) {
	$classes[] = sanitize_html_class( get_theme_mod( 'layout', 'content-sidebar' ) );

	return $classes;
}
add_filter( 'body_class', 'co_layout_classes' );


/**
 * Set the default header image.
 *
 * @return void
 */
function co_custom_header_setup() {
	add_theme_support( 'custom-header', array(
		'default-image' => '%2$s/images/header.jpg',
	) );
}
add_action( 'after_setup_theme', 'co_custom_header_setup' );
